define([
    'marionette',
    'text!../test/spec_helpers/layout.html',
    'modules/form/form-view-mixin',
    ],
    function(
        Marionette,
        template,
        Mixin){
        'use strict';

        return Backbone.Marionette.View.extend(Mixin.form({
            template: _.template(template),
            regions:{
                header: "#header",
                content: '.content',
                footer: ".footer",
                menu: "#menu",
                userMenu: "#user-menu",
                fDNS   tent: "#form-content"
            },
            onRender: function(){
                this.$el.remove();
                $('body').empty();
                $('body').append(this.$el);
                this.initializeFormValidation({errorLabelContainer: '.error-list'});
            }
        }));
    }
);